/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rotationmatrix.h"
#include "gravity_class.h"

RotationMatrix::RotationMatrix()
{
  oxa = 1e30;
  oya = 1e30;
}


RotationMatrix::~RotationMatrix()
{}

void RotationMatrix::populate_matrix(double xa, double ya)
{
  if(xa != oxa || ya != oya)
  {
    // generate trig values
    sy = sin(xa * Gravity::ToRad);
    cy = cos(xa * Gravity::ToRad);
    sx = sin(ya * Gravity::ToRad);
    cx = cos(ya * Gravity::ToRad);
    oxa = xa;
    oya = ya;
  }
}

void RotationMatrix::convert_3d_to_2d(Cart3& v,int anaglyph_flag)
{
  v.x = (v.x * (PerspectiveDepth + v.z))/PerspectiveDepth;
  if(anaglyph_flag)
  {
    v.x += v.z * anaglyph_flag * AnaglyphScale;
  }
  v.y = (v.y * (PerspectiveDepth + v.z))/PerspectiveDepth;
}

void RotationMatrix::rotate(Cart3& v)
{
  double hf = (v.x * sx - v.z * cx);
  double py = v.y * cy + sy * hf;
  double px = v.x * cx + v.z * sx;
  double pz = -v.y * sy + cy * hf;
  v.x = px; v.y = py; v.z = pz;
}

